#include <Core/Core.h>
#include <POP3/POP3.h>

using namespace Upp;

// Helper functions.
String DecodeEncodedString(String& s);
String FindHeadersElement(String& s, String e);


CONSOLE_APP_MAIN
{
	Cout() 	<< "POP3 Example 1\n"
			<< "--------------\n"
			<< "This program demonstrates the simple usage of the POP3 class.\n"
			<< "It will try connecting to the GMail POP3 server and retrieve information\n"
			<< "about your mailbox. (This program requires OpenSSL library)\n\n";
			 
	Cout() << "Your GMail username: ";
	String user = ReadStdIn();
	Cout() << "Your GMail password: ";
	String pass = ReadStdIn();
	Pop3 pop3client;
	pop3client.Host("pop.gmail.com")
              .Port(995)
              .User(user, pass)
              .SSL()
              // Activate logging of Pop3.
              .Trace();
	Cout() 	<< "Connecting to GMail POP3 server... ";
	if(!pop3client.Login()) {
		Cout() << "Failed: " << pop3client.GetLastError() << "\n";
		return;
	}
	Cout() 	<< "Done!\n"
			<< "Reading inbox statistics... ";
	int msgcount = pop3client.GetMessageCount();
	if(msgcount < 0) {
		Cout() << "\nFailed: " << pop3client.GetLastError() << "\n";
		pop3client.Logout();
		return;
	}
	Cout() 	<< "Done!\n\n"
			<< "There are " << msgcount << " messages in your inbox.\n";
	for(;;) {
		Cout() << "Would you like to read a message [only headers]? (y/n): ";
		String response = ReadStdIn();
		if(response == "N" || response == "n")
				break;
		Cout()	<< "Please enter the number of the mail you want to retrieve "
				<< "(should be between 1 and " << msgcount << "): ";
		response = ReadStdIn();
		if(StrInt(response) <= msgcount && StrInt(response) > 0) {
			String message = pop3client.GetMessageHeader(StrInt(response));
			if(!message.IsEmpty()) {	
				Cout() 	<< "\n"
						<< "====================================================================" << "\n"
						<< "| Subject: " << FindHeadersElement(message, "Subject:")		<< "\n"
						<< "| From:    " << FindHeadersElement(message, "From:")		<< "\n"
						<< "| Date:    " << FindHeadersElement(message, "Date:")		<< "\n"
						<< "=====================================================================" << "\n\n";
			}
			else 
				Cout() << "An error encountered: " << pop3client.GetLastError() << "\n";
		continue;
		}
	}
	Cout() << "Logging out!..\n";
	pop3client.Logout();
}
